<?php
    include 'cn/configvisa.php';
    function generateToken() {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => VISA_URL_SECURITY,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
            'Authorization: Basic '.base64_encode(VISA_USER.":".VISA_PWD)
            )
        ));
        $response = curl_exec($curl);
      /*  $mensaje ="ok";
      if (curl_exec($curl)==false) {
    $mensaje = curl_error($curl);
}*/
        curl_close($curl);
    
        return $response;
    }

    function generateSesion($datasesion, $token) {
        $session = array(
            'amount' => $datasesion["importe"],
            'antifraud' => array(
                'clientIp' => $_SERVER['REMOTE_ADDR'],
                'merchantDefineData' => array(
                    'MDD4' => $datasesion["usuario"],
                    'MDD32' => $datasesion["codcli"],
                    'MDD63' => $datasesion["tipodocumento"],
                    'MDD65' => $datasesion["ruccli"],
                    'MDD75' => 'Registrado',
                    'MDD77' => 63
                ),
            ),
            'channel' => 'web',
        );
        $json = json_encode($session);
        $response = json_decode(postRequest(VISA_URL_SESSION, $json, $token));
        return $response->sessionKey;
    }

   function generateAuthorization($amount, $purchaseNumber, $transactionToken, $token) {
       $data = array(
            'antifraud' => null,
            'captureType' => 'manual',
            'channel' => 'web',
            'countable' => true,
            'order' => array(
                'amount' => $amount,
                'currency' => 'PEN',
                'purchaseNumber' => $purchaseNumber,
                'tokenId' => $transactionToken
            ),
            'recurrence' => null,
            'sponsored' => null
        );
        $json = json_encode($data);
        $session = json_decode(postRequest(VISA_URL_AUTHORIZATION, $json, $token));
        return $session;
    }

    function postRequest($url, $postData, $token) {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
                'Authorization: '.$token,
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS => $postData
        ));
        $response = curl_exec($curl);
/*$mensaje ="ok";
      if (curl_exec($curl)==false) {
    $mensaje = curl_error($curl);
}*/
        curl_close($curl);
        return $response;
    }

    function generatePurchaseNumber(){
        $archivo = "assets/purchaseNumber.txt"; 
        $purchaseNumber = 222;
        $fp = fopen($archivo,"r"); 
        $purchaseNumber = fgets($fp, 100);
        fclose($fp); 
        ++$purchaseNumber; 
        $fp = fopen($archivo,"w+"); 
        fwrite($fp, $purchaseNumber, 100); 
        fclose($fp);
        return $purchaseNumber;
    }